/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.cec;

import com.ibm.hsc.auiml.databeans.cec.PIWlmGroupsBean;
import com.ibm.hsc.auiml.databeans.common.TreeTableDisplay;
import com.ibm.hsc.client.PILPARDataBean;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.AuimlAdapter;
import com.ibm.hsc.common.util.PIHscUtil;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.TaskManagerException;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.mobject.MOClass;
import com.ibm.websm.mobject.MOXContainerObj;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class PIWlmGroupsDialog {
    public static final String WLM_GROUP = "Group";
    public static final String PARTITION = "Partition";
    public static final String WLM_PANEL_TITLE = "Work Load Management Groups  - System: ";
    public static final String KEY_SEPARATOR = "~";
    public static final String NAME_SPACE = "nameSpace_Prop";
    public static final String STATE = "STATE";
    public static final String MEMORY = "MEMORY";
    public static final String CPU = "CPU";
    public static final String UNKNOWN = "UNKNOWN";
    public static final String LPAR_BUNDLE = "LPARBundle";
    public static final String BUNDLE_FILE = "PIHSCCommonBundle";
    public static final String NO_GRP_MASK = "65535";
    public static final String NO_GROUPS = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "NONE");
    private static final String AUIML_FILE = "com.ibm.hsc.auiml.databeans.cec.PIWlmGroups";
    private static final String PANEL_NAME = "WlmGrpPanel";
    private static final String DB_STRING = "%%%%%%%% PIWlmGroupsDialog %%%%%%%%";
    private static final String GET_CLUSTER_INFO = "getCECClusterInfo";
    private static final String[] KEYS = new String[]{"lpar_id", "lpar_name", "state", "curr_procs", "curr_mem", "curr_proc_mode", "curr_proc_units"};
    private String m_cecKey;
    private String m_cecName;
    private String m_nameSpace;
    private String m_hostName;
    private MOClass m_moClass;
    private PIWlmGroupsBean m_wlmBean;

    public PIWlmGroupsDialog(MOXContainerObj mOXContainerObj) {
        this.m_cecKey = mOXContainerObj.getKey();
        this.m_cecName = this.m_cecKey.substring(0, this.m_cecKey.indexOf(KEY_SEPARATOR));
        this.m_nameSpace = (String)mOXContainerObj.getPropertyValue(NAME_SPACE);
        this.m_hostName = mOXContainerObj.getHost().getName();
        this.m_moClass = mOXContainerObj.getMOClass();
        this.m_wlmBean = new PIWlmGroupsBean();
        if (IDebug.enabled()) {
            System.err.println("%%%%%%%% PIWlmGroupsDialog %%%%%%%%PIWlmGroupsDialog()>>>>cecName: " + this.m_cecName + "nameSpace: " + this.m_nameSpace + "hostName: " + this.m_hostName + "moClass: " + this.m_moClass);
        }
    }

    public void showDialog() {
        AuimlAdapter auimlAdapter;
        block4: {
            auimlAdapter = null;
            try {
                this.loadTree();
            }
            catch (PIHscClientException pIHscClientException) {
                if (!IDebug.enabled()) break block4;
                System.err.println("%%%%%%%% PIWlmGroupsDialog %%%%%%%% showDialog()>>>>> Exception ..");
                pIHscClientException.printStackTrace();
            }
        }
        try {
            auimlAdapter = new AuimlAdapter(AUIML_FILE, PANEL_NAME, new DataBean[]{this.m_wlmBean});
            auimlAdapter.showIt();
        }
        catch (TaskManagerException taskManagerException) {
            System.err.println("%%%%%%%% PIWlmGroupsDialog %%%%%%%% showDialog()>>>>>>>");
            taskManagerException.printStackTrace();
            return;
        }
        System.err.println("~~~~~~~~~ EveryThingCool ~~~~~~~~~~");
    }

    private void loadTree() throws PIHscClientException {
        HashMap hashMap;
        try {
            Object[] objectArray = new Object[]{this.m_hostName, this.m_nameSpace, this.m_cecName};
            hashMap = (HashMap)this.m_moClass.invokeStaticMethod(GET_CLUSTER_INFO, objectArray);
        }
        catch (PIHscClientException pIHscClientException) {
            if (IDebug.enabled()) {
                System.err.println("%%%%%%%% PIWlmGroupsDialog %%%%%%%%loadTree() **** Error ****");
                pIHscClientException.printStackTrace();
            }
            return;
        }
        catch (Exception exception) {
            if (IDebug.enabled()) {
                System.err.println("%%%%%%%% PIWlmGroupsDialog %%%%%%%%loadTree() **** Error ****");
                exception.printStackTrace();
            }
            return;
        }
        this.m_wlmBean.load();
        if (hashMap != null) {
            this.setTree(hashMap);
        }
    }

    private void setTree(HashMap hashMap) {
        TreeTableDisplay treeTableDisplay = new TreeTableDisplay("System", this.m_cecName, "images/hsc_managed_sys.t.gif");
        Set set = hashMap.keySet();
        Object[] objectArray = set.toArray(new String[0]);
        Arrays.sort(objectArray);
        HashMap<String, PILPARDataBean> hashMap2 = null;
        for (int i = 0; i < objectArray.length; ++i) {
            HashMap<String, Object> hashMap3;
            Object object = objectArray[i];
            PILPARDataBean[] pILPARDataBeanArray = (PILPARDataBean[])hashMap.get(object);
            hashMap2 = new HashMap<String, PILPARDataBean>();
            for (int j = 0; j < pILPARDataBeanArray.length; ++j) {
                hashMap2.put(pILPARDataBeanArray[j].getUserDefinedName(), pILPARDataBeanArray[j]);
            }
            Set set2 = hashMap2.keySet();
            Object[] objectArray2 = set2.toArray(new String[0]);
            Arrays.sort(objectArray2);
            int n = 0;
            double d = 0.0;
            if (((String)object).equals(NO_GRP_MASK)) {
                object = NO_GROUPS;
            }
            TreeTableDisplay treeTableDisplay2 = new TreeTableDisplay((String)object, (String)object, "images/p_wlm.t.gif");
            for (int j = 0; j < objectArray2.length; ++j) {
                Integer n2;
                UnsignedInt32 unsignedInt32;
                Number number;
                PILPARDataBean pILPARDataBean = (PILPARDataBean)hashMap2.get(objectArray2[j]);
                String string = pILPARDataBean.getUserDefinedName();
                String string2 = pILPARDataBean.getLparID().toString();
                string = string + "(" + string2 + ")";
                UnsignedInt8 unsignedInt8 = pILPARDataBean.getState();
                String string3 = unsignedInt8 != null ? PIHscUtil.getLparStateString(unsignedInt8) : UNKNOWN;
                unsignedInt8 = pILPARDataBean.getCurProcType();
                System.err.println("CurrProcType == " + unsignedInt8);
                if (unsignedInt8 != null) {
                    if (unsignedInt8.shortValue() == 255) {
                        UnsignedInt16 unsignedInt16 = pILPARDataBean.getCurAllocProcs();
                        System.err.println("Proc Type DEDICATED : " + unsignedInt16);
                        if (unsignedInt16 != null) {
                            d += (double)unsignedInt16.intValue();
                            number = new Integer(unsignedInt16.intValue());
                        } else {
                            number = new Integer(0);
                        }
                    } else {
                        unsignedInt32 = pILPARDataBean.getCurAllocProcUnits();
                        System.err.println("Curr Proc Type shared :" + unsignedInt32);
                        if (unsignedInt32 != null) {
                            d += (double)unsignedInt32.intValue() / 100.0;
                            number = new Double((double)unsignedInt32.intValue() / 100.0);
                        } else {
                            number = new Integer(0);
                        }
                    }
                } else {
                    number = new Integer(0);
                }
                unsignedInt32 = pILPARDataBean.getCurAllocMem();
                if (unsignedInt32 != null) {
                    n += unsignedInt32.intValue();
                    n2 = new Integer(unsignedInt32.intValue());
                } else {
                    n2 = new Integer(0);
                }
                hashMap3 = new HashMap();
                hashMap3.put(MEMORY, n2);
                hashMap3.put(STATE, string3);
                hashMap3.put(CPU, number);
                TreeTableDisplay treeTableDisplay3 = new TreeTableDisplay(string + string2, string, "images/D_console.t.gif");
                treeTableDisplay3.setRowData(hashMap3);
                treeTableDisplay2.addChild(treeTableDisplay3);
            }
            hashMap3 = new HashMap<String, Object>();
            hashMap3.put(STATE, "");
            hashMap3.put(CPU, new Double(d));
            hashMap3.put(MEMORY, new Integer(n));
            treeTableDisplay2.setRowData(hashMap3);
            treeTableDisplay.addChild(treeTableDisplay2);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(CPU);
        arrayList.add(MEMORY);
        arrayList.add(STATE);
        this.m_wlmBean.initIOTable(treeTableDisplay, arrayList);
    }
}

